import subprocess
from datetime import datetime

# Rsync over SSH with key authentication
def run_rsync():
    ssh_user = "user"
    ssh_host = "prod-10.domain.com"  # Hostname or IP
    ssh_path = "/zvol_1/"  # Path on remote server
    destination = "/zvol_2/prod-10/" 
    ssh_key_path = "/path/to/your/private_key"  # Update this to your private SSH key path

# Update Log File Path
    log_file = f"/path/to/logs/rsync_log_{datetime.now().strftime('%Y%m%d_%H%M%S')}.txt"
    source = f"{ssh_user}@{ssh_host}:{ssh_path}"

    rsync_command = [
        "rsync", "-avz", "--delete", "-e",
        f"ssh -i {ssh_key_path} -T -c aes128-ctr -o Compression=no -x",
        source, destination
    ]

    try:
        print("Running rsync via ssh key authentication...")
        process = subprocess.run(
            rsync_command,
            text=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE
        )

        with open(log_file, "w") as log:
            log.write("RSYNC OUTPUT:\n")
            log.write(process.stdout)
            log.write("\n\nRSYNC ERRORS:\n")
            log.write(process.stderr)

        print(f"Rsync completed. Logs saved to {log_file}")

    except FileNotFoundError as e:
        print(f"Error: Required command not found: {e}")
    except Exception as e:
        print(f"An error occurred: {e}")

if __name__ == "__main__":
    run_rsync()