import subprocess
from datetime import datetime
import re

def run_rsync():
    # Define SSH and source details
    ssh_user = "user"  # User
    ssh_host = "x.x.x.x"  # IP Address or Hostname
    ssh_path = "/zvol_1/"  # Source

    # Define destination path
    destination = "/zvol_2/server-10/"

    # Define SSH password (plain text, not secure for production!)
    password = "password"

    # Define log file location
    log_file = f"/path/to/logs/rsync_log_{datetime.now().strftime('%Y%m%d_%H%M%S')}.txt"

    # Construct source from parts
    source = f"{ssh_user}@{ssh_host}:{ssh_path}"

    # The rsync command
    rsync_command = [
        "rsync", "-avz", "--delete", "-e", "ssh -T -c aes128-ctr -o Compression=no -x",
        source,
        destination
    ]

    try:
        print("Running rsync via ssh...")

        # Run the rsync command and pass the password using sshpass
        process = subprocess.run(
            ["sshpass", "-p", password] + rsync_command,
            text=True,
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE
        )

        # Write the output and errors to the log file
        with open(log_file, "w") as log:
            log.write("RSYNC OUTPUT:\n")
            log.write(process.stdout)
            log.write("\n\nRSYNC ERRORS:\n")
            log.write(process.stderr)

        print(f"Rsync completed. Logs saved to {log_file}")

    except FileNotFoundError:
        print("Error: sshpass is not installed. Please install it with 'sudo apt install sshpass'.")
    except Exception as e:
        print(f"An error occurred: {e}")

if __name__ == "__main__":
    run_rsync()